/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public final class ButtonAreaLayout
implements LayoutManager {
    private int gap;

    public ButtonAreaLayout(int gap) {
        this.gap = gap;
    }

    public void addLayoutComponent(String string, Component comp) {
    }

    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        Component[] children = container.getComponents();
        int maxWidth = 0;
        int maxHeight = 0;
        int visibleCount = 0;
        int c = children.length;
        for (int i = 0; i < c; ++i) {
            if (!children[i].isVisible()) continue;
            Dimension componentPreferredSize = children[i].getPreferredSize();
            maxWidth = Math.max(maxWidth, componentPreferredSize.width);
            maxHeight = Math.max(maxHeight, componentPreferredSize.height);
            ++visibleCount;
        }
        int usedWidth = maxWidth * visibleCount + this.gap * (visibleCount - 1);
        int c2 = children.length;
        for (int i = 0; i < c2; ++i) {
            if (!children[i].isVisible()) continue;
            children[i].setBounds(container.getWidth() - insets.right - usedWidth + (maxWidth + this.gap) * i, insets.top, maxWidth, maxHeight);
        }
    }

    public Dimension minimumLayoutSize(Container c) {
        return this.preferredLayoutSize(c);
    }

    public Dimension preferredLayoutSize(Container container) {
        Insets insets = container.getInsets();
        Component[] children = container.getComponents();
        int maxWidth = 0;
        int maxHeight = 0;
        int visibleCount = 0;
        int c = children.length;
        for (int i = 0; i < c; ++i) {
            if (!children[i].isVisible()) continue;
            Dimension componentPreferredSize = children[i].getPreferredSize();
            maxWidth = Math.max(maxWidth, componentPreferredSize.width);
            maxHeight = Math.max(maxHeight, componentPreferredSize.height);
            ++visibleCount;
        }
        int usedWidth = maxWidth * visibleCount + this.gap * (visibleCount - 1);
        return new Dimension(insets.left + usedWidth + insets.right, insets.top + maxHeight + insets.bottom);
    }

    public void removeLayoutComponent(Component c) {
    }
}

