/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.product.diagram.classes;

import com.horstmann.violet.framework.diagram.Grid;
import com.horstmann.violet.framework.diagram.MultiLineString;
import com.horstmann.violet.framework.diagram.Node;
import com.horstmann.violet.framework.diagram.RectangularNode;
import com.horstmann.violet.product.diagram.common.PointNode;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;

public class InterfaceNode
extends RectangularNode {
    private transient double midHeight;
    private transient double botHeight;
    private MultiLineString name = new MultiLineString();
    private MultiLineString methods;
    private static int DEFAULT_COMPARTMENT_HEIGHT = 20;
    private static int DEFAULT_WIDTH = 100;
    private static int DEFAULT_HEIGHT = 60;

    public InterfaceNode() {
        this.name.setSize(3);
        this.name.setText("\u00abinterface\u00bb");
        this.methods = new MultiLineString();
        this.methods.setJustification(0);
        this.setBounds(new Rectangle2D.Double(0.0, 0.0, DEFAULT_WIDTH, DEFAULT_HEIGHT));
        this.midHeight = DEFAULT_COMPARTMENT_HEIGHT;
        this.botHeight = DEFAULT_COMPARTMENT_HEIGHT;
    }

    @Override
    public void draw(Graphics2D g2) {
        super.draw(g2);
        Rectangle2D.Double top = new Rectangle2D.Double(this.getBounds().getX(), this.getBounds().getY(), this.getBounds().getWidth(), this.getBounds().getHeight() - this.midHeight - this.botHeight);
        g2.draw(top);
        this.name.draw(g2, top);
        Rectangle2D.Double mid = new Rectangle2D.Double(((RectangularShape)top).getX(), top.getMaxY(), ((RectangularShape)top).getWidth(), this.midHeight);
        g2.draw(mid);
        Rectangle2D.Double bot = new Rectangle2D.Double(((RectangularShape)top).getX(), mid.getMaxY(), ((RectangularShape)top).getWidth(), this.botHeight);
        g2.draw(bot);
        this.methods.draw(g2, bot);
    }

    @Override
    public void layout(Graphics2D g2, Grid grid) {
        Rectangle2D.Double min = new Rectangle2D.Double(0.0, 0.0, DEFAULT_WIDTH, DEFAULT_COMPARTMENT_HEIGHT);
        Rectangle2D top = this.name.getBounds(g2);
        top.add(min);
        Rectangle2D bot = this.methods.getBounds(g2);
        this.botHeight = bot.getHeight();
        if (this.botHeight == 0.0) {
            top.add(new Rectangle2D.Double(0.0, 0.0, DEFAULT_WIDTH, DEFAULT_HEIGHT));
            this.midHeight = 0.0;
        } else {
            bot.add(min);
            this.midHeight = DEFAULT_COMPARTMENT_HEIGHT;
            this.botHeight = bot.getHeight();
        }
        this.snapBounds(grid, Math.max(top.getWidth(), bot.getWidth()), top.getHeight() + this.midHeight + this.botHeight);
    }

    @Override
    public boolean checkAddNode(Node n, Point2D p) {
        return n instanceof PointNode;
    }

    public void setName(MultiLineString newValue) {
        this.name = newValue;
    }

    public MultiLineString getName() {
        return this.name;
    }

    public void setMethods(MultiLineString newValue) {
        this.methods = newValue;
    }

    public MultiLineString getMethods() {
        return this.methods;
    }

    @Override
    public InterfaceNode clone() {
        InterfaceNode cloned = (InterfaceNode)super.clone();
        cloned.name = this.name.clone();
        cloned.methods = this.methods.clone();
        return cloned;
    }
}

