/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.product.diagram.activity;

import com.horstmann.violet.framework.diagram.Direction;
import com.horstmann.violet.framework.diagram.Edge;
import com.horstmann.violet.framework.diagram.Grid;
import com.horstmann.violet.framework.diagram.Node;
import com.horstmann.violet.framework.diagram.RectangularNode;
import com.horstmann.violet.product.diagram.common.PointNode;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class SynchronizationBarNode
extends RectangularNode {
    private static int DEFAULT_WIDTH = 150;
    private static int DEFAULT_HEIGHT = 4;
    private static int EXTRA_WIDTH = 12;

    public SynchronizationBarNode() {
        this.setBounds(new Rectangle2D.Double(0.0, 0.0, DEFAULT_WIDTH, DEFAULT_HEIGHT));
    }

    @Override
    public boolean checkAddEdge(Edge e, Point2D p1, Point2D p2) {
        return e.getEnd() != null && this != e.getEnd();
    }

    @Override
    public void layout(Graphics2D g2, Grid grid) {
        ArrayList<Node> connectedNodes = new ArrayList<Node>();
        for (Edge e : this.getGraph().getEdges()) {
            if (e.getStart() == this) {
                connectedNodes.add(e.getEnd());
            }
            if (e.getEnd() != this) continue;
            connectedNodes.add(e.getStart());
        }
        Rectangle2D b = this.getBounds();
        if (connectedNodes.size() > 0) {
            double centerY = b.getCenterY();
            double minX = Double.MAX_VALUE;
            double maxX = Double.MIN_VALUE;
            for (Node n : connectedNodes) {
                double y = n.getBounds().getCenterY();
                Direction d = y <= centerY ? Direction.NORTH : Direction.SOUTH;
                Point2D c = n.getConnectionPoint(d);
                minX = Math.min(minX, c.getX());
                maxX = Math.max(maxX, c.getX());
            }
            this.translate((minX -= (double)EXTRA_WIDTH) - this.getLocation().getX(), b.getY() - this.getLocation().getY());
            b = new Rectangle2D.Double(minX, b.getY(), (maxX += (double)EXTRA_WIDTH) - minX, DEFAULT_HEIGHT);
            this.setBounds(b);
        }
    }

    @Override
    public void draw(Graphics2D g2) {
        super.draw(g2);
        g2.fill(this.getShape());
    }

    @Override
    public boolean checkAddNode(Node n, Point2D p) {
        return n instanceof PointNode;
    }
}

