/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.framework.swingextension;

import com.horstmann.violet.framework.gui.theme.ThemeManager;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicButtonUI;

public class RolloverButtonUI
extends BasicButtonUI {
    private Color defaultColor;
    private Color rolloverColor;
    private Color rolloverBorderColor;
    private static final int HGAP = 6;
    private static final int VGAP = 2;

    public RolloverButtonUI(Color rolloverColor, Color rolloverBorderColor, Color defaultColor) {
        this.defaultColor = defaultColor;
        this.rolloverColor = rolloverColor;
        this.rolloverBorderColor = rolloverBorderColor;
    }

    @Override
    protected void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        b.setOpaque(true);
        b.setBorderPainted(false);
        b.setRolloverEnabled(true);
        b.setFont(b.getFont().deriveFont(0));
        b.setBorder(new EmptyBorder(2, 6, 2, 6));
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        this.clearTextShiftOffset();
        Color borderColor = this.defaultColor;
        Color startColor = this.defaultColor;
        Color endColor = this.defaultColor;
        if (model.isArmed() && model.isPressed()) {
            borderColor = this.rolloverBorderColor;
            startColor = this.rolloverColor;
            endColor = this.rolloverColor.brighter().brighter();
        } else if (model.isRollover()) {
            borderColor = this.rolloverBorderColor;
            startColor = this.rolloverColor.brighter().brighter();
            endColor = this.rolloverColor;
        }
        this.paintBackground(g, startColor, endColor, c);
        this.paintBorder(g, borderColor, c);
        this.paintText(g, c);
    }

    private void paintText(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        String text = b.getText();
        Color currentColor = g.getColor();
        g.setColor(this.rolloverBorderColor);
        FontMetrics fontMetrics = g.getFontMetrics();
        Rectangle2D stringBounds = fontMetrics.getStringBounds(text, g);
        g.setFont(ThemeManager.getInstance().getTheme().getTOGGLEBUTTON_FONT());
        g.drawString(text, (int)((double)(c.getWidth() / 2) - stringBounds.getWidth() / 2.0), (int)((double)(c.getHeight() / 2) + stringBounds.getHeight() / 2.0 - 2.0));
        g.setColor(currentColor);
    }

    private void paintBackground(Graphics g, Color startColor, Color endColor, JComponent c) {
        Graphics2D g2 = (Graphics2D)g;
        Paint currentPaint = g2.getPaint();
        GradientPaint paint = new GradientPaint(c.getWidth() / 2, -c.getHeight() * 2, startColor, c.getWidth() / 2, c.getHeight() + c.getHeight() / 4, endColor);
        g2.setPaint(paint);
        g2.fillRect(0, 0, c.getWidth(), c.getHeight());
        g2.setPaint(currentPaint);
    }

    private void paintBorder(Graphics g, Color borderColor, JComponent c) {
        Color currentColor = g.getColor();
        g.setColor(borderColor);
        g.drawRect(0, 0, c.getWidth() - 1, c.getHeight() - 1);
        g.setColor(currentColor);
    }
}

