/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.framework.network;

import com.horstmann.violet.framework.diagram.Edge;
import com.horstmann.violet.framework.diagram.Graph;
import com.horstmann.violet.framework.diagram.Node;
import com.horstmann.violet.framework.gui.DiagramPanel;
import com.horstmann.violet.framework.gui.DialogFactory;
import com.horstmann.violet.framework.gui.GraphPanel;
import com.horstmann.violet.framework.gui.PropertySheet;
import com.horstmann.violet.framework.network.NetworkManager;
import com.horstmann.violet.framework.network.NetworkMessageSubjectType;
import com.horstmann.violet.framework.network.NetworkSession;
import com.horstmann.violet.framework.network.config.HTTPGuestConfig;
import com.horstmann.violet.framework.network.config.HTTPHostConfig;
import com.horstmann.violet.framework.network.config.IGuestNetworkConfig;
import com.horstmann.violet.framework.network.config.IHostNetworkConfig;
import com.horstmann.violet.framework.network.config.INetworkConfig;
import com.horstmann.violet.framework.util.PropertyUtils;
import java.awt.geom.Point2D;
import java.net.URL;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class NetworkAction {
    private ResourceBundle resourceBundle = ResourceBundle.getBundle("properties.NetworkStrings", Locale.getDefault());
    private IHostNetworkConfig hostNetworkConfig;
    private IGuestNetworkConfig guestNetworkConfig;

    public void shareDiagramPanel(DiagramPanel dPanel) {
        IHostNetworkConfig config = this.getHostNetworkConfig();
        boolean isValidated = this.editConfig(config);
        if (!isValidated) {
            return;
        }
        NetworkManager networkManager = this.getNetworkManager();
        NetworkSession session = networkManager.getStandardSession(config.getUserID(), config.getLocalURL());
        networkManager.attachDiagramToSession(dPanel, session);
    }

    private boolean editConfig(INetworkConfig networkConfig) {
        Object backup = null;
        try {
            backup = networkConfig.clone();
        }
        catch (CloneNotSupportedException e) {
            // empty catch block
        }
        PropertySheet sheet = new PropertySheet(networkConfig);
        JOptionPane optionPane = new JOptionPane();
        optionPane.setOpaque(false);
        optionPane.setMessage(sheet.getComponent());
        optionPane.setOptionType(2);
        DialogFactory.getInstance().showDialog(optionPane, this.resourceBundle.getString("dialog.network_config.title"), true);
        int result = 2;
        if (!JOptionPane.UNINITIALIZED_VALUE.equals(optionPane.getValue())) {
            result = (Integer)optionPane.getValue();
        }
        if (result == 0) {
            networkConfig.savePreferedValues();
            return true;
        }
        PropertyUtils.copyProperties(backup, networkConfig);
        return false;
    }

    public void openRemoteDiagram() {
        IGuestNetworkConfig config = this.getGuestNetworkConfig();
        boolean isValidated = this.editConfig(config);
        if (!isValidated) {
            return;
        }
        NetworkManager networkManager = this.getNetworkManager();
        NetworkSession session = networkManager.getStandardSession(config.getUserID(), config.getLocalURL());
        networkManager.sendMessageToRecipient(session, NetworkMessageSubjectType.REQUEST_SHARED_DIAGRAMS_LIST, "", config.getServerURL());
        config.savePreferedValues();
    }

    public void selectDiagramFromList(SortedMap<String, String> sharedDiagramsList, String senderID, URL senderURL) {
        Set<String> diagramIds = sharedDiagramsList.keySet();
        ArrayList<String> titles = new ArrayList<String>();
        for (String id : diagramIds) {
            String aTitle = ((String)sharedDiagramsList.get(id)).toString();
            titles.add(aTitle);
        }
        String[] titleArray = titles.toArray(new String[titles.size()]);
        JList<String> list = new JList<String>(titleArray);
        list.setOpaque(true);
        JPanel panel = new JPanel();
        panel.add(list);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.getViewport().add(list);
        scrollPane.setSize(300, 400);
        JOptionPane optionPane = new JOptionPane();
        optionPane.setMessage(scrollPane);
        optionPane.setOptionType(2);
        optionPane.setOpaque(false);
        DialogFactory.getInstance().showDialog(optionPane, "Select a diagram", true);
        int result = 2;
        if (!JOptionPane.UNINITIALIZED_VALUE.equals(optionPane.getValue())) {
            result = (Integer)optionPane.getValue();
        }
        if (result == 0) {
            int index = list.getSelectedIndex();
            if (index == -1) {
                return;
            }
            String[] ids = diagramIds.toArray(new String[diagramIds.size()]);
            String selectedId = ids[index];
            DiagramPanel diagramPanel = new DiagramPanel(selectedId);
            diagramPanel.setTitle("Waiting for remote diagram...");
            NetworkManager networkManager = this.getNetworkManager();
            networkManager.registerNewDiagramPanel(diagramPanel);
            IGuestNetworkConfig config = this.getGuestNetworkConfig();
            NetworkSession session = networkManager.getStandardSession(config.getUserID(), config.getLocalURL());
            session.addRecipient(senderID, senderURL);
            networkManager.attachDiagramToSession(diagramPanel, session);
            networkManager.sendMessageToRecipient(session, NetworkMessageSubjectType.REQUEST_GRAPH_REFRESH, selectedId, senderURL);
        }
    }

    public void sendSharedDiagramsList(URL senderURL) {
        NetworkManager manager = this.getNetworkManager();
        DiagramPanel[] sharedDiagramPanels = manager.getSharedDiagramPanels();
        TreeMap<String, String> sharedDiagramsList = new TreeMap<String, String>();
        for (int i = 0; i < sharedDiagramPanels.length; ++i) {
            DiagramPanel aPanel = sharedDiagramPanels[i];
            sharedDiagramsList.put(aPanel.getId(), aPanel.getTitle());
        }
        IHostNetworkConfig config = this.getHostNetworkConfig();
        NetworkSession sendingSession = manager.getSendingOnlySession(config.getUserID(), config.getLocalURL());
        manager.sendMessageToRecipient(sendingSession, NetworkMessageSubjectType.SHARED_DIAGRAMS_LIST, sharedDiagramsList, senderURL);
    }

    public void receiveNewNode(NetworkSession session, Node newNode, URL senderURL) {
        NetworkManager networkManager = this.getNetworkManager();
        DiagramPanel sharedDiagramPanel = networkManager.getAttachedDiagram(session);
        GraphPanel graphPanel = sharedDiagramPanel.getGraphPanel();
        Graph graph = graphPanel.getGraph();
        double posX = newNode.getBounds().getX();
        double posY = newNode.getBounds().getY();
        Point2D.Double location = new Point2D.Double(posX, posY);
        if (graph.findNode(newNode.getId()) == null) {
            graphPanel.addNodeAtPoint(newNode, location);
            graphPanel.repaint();
        }
    }

    public void receiveDeletedNode(NetworkSession session, Node removedNode, URL senderURL) {
        NetworkManager networkManager = this.getNetworkManager();
        DiagramPanel sharedDiagramPanel = networkManager.getAttachedDiagram(session);
        GraphPanel graphPanel = sharedDiagramPanel.getGraphPanel();
        Graph graph = graphPanel.getGraph();
        Node localNodeToDelete = graph.findNode(removedNode.getId());
        if (localNodeToDelete != null) {
            graphPanel.removeNode(localNodeToDelete);
            graphPanel.repaint();
        }
    }

    public void receiveUpdatedNode(NetworkSession session, Node updatedNode, URL senderURL) {
        NetworkManager networkManager = this.getNetworkManager();
        DiagramPanel sharedDiagramPanel = networkManager.getAttachedDiagram(session);
        GraphPanel graphPanel = sharedDiagramPanel.getGraphPanel();
        Graph graph = graphPanel.getGraph();
        Node localNodeToUpdate = graph.findNode(updatedNode.getId());
        if (localNodeToUpdate != null) {
            if (updatedNode.getRevision() <= localNodeToUpdate.getRevision()) {
                return;
            }
            graphPanel.updateNode(updatedNode, localNodeToUpdate);
            graphPanel.repaint();
        }
        if (localNodeToUpdate == null) {
            double posX = updatedNode.getBounds().getX();
            double posY = updatedNode.getBounds().getY();
            Point2D.Double location = new Point2D.Double(posX, posY);
            graphPanel.addNodeAtPoint(updatedNode, location);
            graphPanel.repaint();
        }
    }

    public void receiveNewEdge(NetworkSession session, Edge newEdge, URL senderURL) {
        NetworkManager networkManager = this.getNetworkManager();
        DiagramPanel sharedDiagramPanel = networkManager.getAttachedDiagram(session);
        GraphPanel graphPanel = sharedDiagramPanel.getGraphPanel();
        Graph graph = graphPanel.getGraph();
        if (graph.findEdge(newEdge.getId()) == null) {
            String startNodeId = newEdge.getStart().getId();
            String endNodeId = newEdge.getEnd().getId();
            Node startNode = graph.findNode(startNodeId);
            Node endNode = graph.findNode(endNodeId);
            if (startNode != null && endNode != null) {
                double startPosX = startNode.getBounds().getX();
                double startPosY = startNode.getBounds().getY();
                double endPosX = endNode.getBounds().getX();
                double endPosY = endNode.getBounds().getY();
                Point2D.Double startPoint = new Point2D.Double(startPosX, startPosY);
                Point2D.Double endPoint = new Point2D.Double(endPosX, endPosY);
                graphPanel.addEdgeAtPoints(newEdge, startPoint, endPoint);
                graphPanel.repaint();
            }
        }
    }

    public void receiveUpdatedEdge(NetworkSession session, Edge updatedEdge, URL senderURL) {
        NetworkManager networkManager = this.getNetworkManager();
        DiagramPanel sharedDiagramPanel = networkManager.getAttachedDiagram(session);
        GraphPanel graphPanel = sharedDiagramPanel.getGraphPanel();
        Graph graph = graphPanel.getGraph();
        Edge localEdgeToUpdate = graph.findEdge(updatedEdge.getId());
        if (localEdgeToUpdate != null) {
            if (updatedEdge.getRevision() <= localEdgeToUpdate.getRevision()) {
                return;
            }
            graphPanel.updateEdge(updatedEdge, localEdgeToUpdate);
            graphPanel.repaint();
        }
        if (localEdgeToUpdate == null) {
            String startNodeId = updatedEdge.getStart().getId();
            String endNodeId = updatedEdge.getEnd().getId();
            Node startNode = graph.findNode(startNodeId);
            Node endNode = graph.findNode(endNodeId);
            if (startNode != null && endNode != null) {
                double startPosX = startNode.getBounds().getX();
                double startPosY = startNode.getBounds().getY();
                double endPosX = endNode.getBounds().getX();
                double endPosY = endNode.getBounds().getY();
                Point2D.Double startPoint = new Point2D.Double(startPosX, startPosY);
                Point2D.Double endPoint = new Point2D.Double(endPosX, endPosY);
                graphPanel.addEdgeAtPoints(updatedEdge, startPoint, endPoint);
                graphPanel.repaint();
            }
        }
    }

    public void receiveDeletedEdge(NetworkSession session, Edge deletedEdge, URL senderURL) {
        NetworkManager networkManager = this.getNetworkManager();
        DiagramPanel sharedDiagramPanel = networkManager.getAttachedDiagram(session);
        GraphPanel graphPanel = sharedDiagramPanel.getGraphPanel();
        Graph graph = graphPanel.getGraph();
        Edge localEdgeToDelete = graph.findEdge(deletedEdge.getId());
        if (localEdgeToDelete != null) {
            graphPanel.removeEdge(localEdgeToDelete);
            graphPanel.repaint();
        }
    }

    public void receiveUpdatedGraph(NetworkSession session, Graph updatedGraph) {
        NetworkManager networkManager = this.getNetworkManager();
        DiagramPanel sharedDiagramPanel = networkManager.getAttachedDiagram(session);
        sharedDiagramPanel.setGraph(updatedGraph);
    }

    public void requestGraphRefresh(String sharedDiagramPanelId) {
        NetworkSession session = this.getNetworkManager().getNetworkSession(sharedDiagramPanelId);
        this.getNetworkManager().sendMessageToAll(session, NetworkMessageSubjectType.REQUEST_GRAPH_REFRESH, "");
    }

    public void sendGraph(NetworkSession session, URL recipientURL, Graph graph) {
        this.getNetworkManager().sendMessageToRecipient(session, NetworkMessageSubjectType.GRAPH_UPDATED, graph, recipientURL);
    }

    public void sendAddedNode(DiagramPanel shareDiagramPanel, Node node) {
        NetworkSession session = this.getNetworkManager().getNetworkSession(shareDiagramPanel.getId());
        if (session != null) {
            this.getNetworkManager().sendMessageToAll(session, NetworkMessageSubjectType.NODE_ADDED, node);
        }
    }

    public void sendModifiedNode(DiagramPanel shareDiagramPanel, Node node) {
        NetworkSession session = this.getNetworkManager().getNetworkSession(shareDiagramPanel.getId());
        if (session != null) {
            this.getNetworkManager().sendMessageToAll(session, NetworkMessageSubjectType.NODE_UPDATED, node);
        }
    }

    public void sendRemovedNode(DiagramPanel shareDiagramPanel, Node node) {
        NetworkSession session = this.getNetworkManager().getNetworkSession(shareDiagramPanel.getId());
        if (session != null) {
            this.getNetworkManager().sendMessageToAll(session, NetworkMessageSubjectType.NODE_DELETED, node);
        }
    }

    public void sendAddedEdge(DiagramPanel shareDiagramPanel, Edge edge) {
        NetworkSession session = this.getNetworkManager().getNetworkSession(shareDiagramPanel.getId());
        if (session != null) {
            this.getNetworkManager().sendMessageToAll(session, NetworkMessageSubjectType.EDGE_ADDED, edge);
        }
    }

    public void sendModifiedEdge(DiagramPanel shareDiagramPanel, Edge edge) {
        NetworkSession session = this.getNetworkManager().getNetworkSession(shareDiagramPanel.getId());
        if (session != null) {
            this.getNetworkManager().sendMessageToAll(session, NetworkMessageSubjectType.EDGE_UPDATED, edge);
        }
    }

    public void sendRemovedEdge(DiagramPanel shareDiagramPanel, Edge edge) {
        NetworkSession session = this.getNetworkManager().getNetworkSession(shareDiagramPanel.getId());
        if (session != null) {
            this.getNetworkManager().sendMessageToAll(session, NetworkMessageSubjectType.EDGE_DELETED, edge);
        }
    }

    private NetworkManager getNetworkManager() {
        return NetworkManager.getInstance();
    }

    private IHostNetworkConfig getHostNetworkConfig() {
        if (this.hostNetworkConfig == null) {
            this.hostNetworkConfig = new HTTPHostConfig();
            this.hostNetworkConfig.loadPreferedValues();
        }
        return this.hostNetworkConfig;
    }

    private IGuestNetworkConfig getGuestNetworkConfig() {
        if (this.guestNetworkConfig == null) {
            this.guestNetworkConfig = new HTTPGuestConfig();
            this.guestNetworkConfig.loadPreferedValues();
        }
        return this.guestNetworkConfig;
    }
}

