/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.framework.file;

import com.horstmann.violet.framework.diagram.ArrowHead;
import com.horstmann.violet.framework.diagram.BentStyle;
import com.horstmann.violet.framework.diagram.LineStyle;
import com.horstmann.violet.framework.util.StringFilterOutputStream;
import com.horstmann.violet.product.diagram.classes.ClassDiagramGraph;
import com.horstmann.violet.product.diagram.classes.ClassNode;
import com.horstmann.violet.product.diagram.classes.ClassRelationshipEdge;
import com.horstmann.violet.product.diagram.classes.InterfaceNode;
import com.horstmann.violet.product.diagram.classes.PackageNode;
import com.horstmann.violet.product.diagram.common.DiagramLinkNode;
import com.horstmann.violet.product.diagram.common.NoteEdge;
import com.horstmann.violet.product.diagram.common.NoteNode;
import com.horstmann.violet.product.diagram.common.PointNode;
import com.horstmann.violet.product.diagram.object.FieldNode;
import com.horstmann.violet.product.diagram.object.ObjectDiagramGraph;
import com.horstmann.violet.product.diagram.object.ObjectNode;
import com.horstmann.violet.product.diagram.object.ObjectReferenceEdge;
import com.horstmann.violet.product.diagram.object.ObjectRelationshipEdge;
import com.horstmann.violet.product.diagram.sequence.ActivationBarNode;
import com.horstmann.violet.product.diagram.sequence.CallEdge;
import com.horstmann.violet.product.diagram.sequence.LifelineNode;
import com.horstmann.violet.product.diagram.sequence.ReturnEdge;
import com.horstmann.violet.product.diagram.sequence.SequenceDiagramGraph;
import com.horstmann.violet.product.diagram.state.CircularInitialStateNode;
import com.horstmann.violet.product.diagram.state.StateDiagramGraph;
import com.horstmann.violet.product.diagram.state.StateNode;
import com.horstmann.violet.product.diagram.state.StateTransitionEdge;
import com.horstmann.violet.product.diagram.usecase.ActorNode;
import com.horstmann.violet.product.diagram.usecase.UseCaseDiagramGraph;
import com.horstmann.violet.product.diagram.usecase.UseCaseNode;
import com.horstmann.violet.product.diagram.usecase.UseCaseRelationshipEdge;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;

public class FileFormatService {
    public static InputStream convertFromViolet016(InputStream in) {
        Hashtable<String, String> replaceMap = new Hashtable<String, String>();
        replaceMap.put("com.horstmann.violet.BentStyle", BentStyle.class.getName());
        replaceMap.put("com.horstmann.violet.LineStyle", LineStyle.class.getName());
        replaceMap.put("com.horstmann.violet.ArrowHead", ArrowHead.class.getName());
        replaceMap.put("com.horstmann.violet.ClassDiagramGraph", ClassDiagramGraph.class.getName());
        replaceMap.put("com.horstmann.violet.ClassNode", ClassNode.class.getName());
        replaceMap.put("com.horstmann.violet.ClassRelationshipEdge", ClassRelationshipEdge.class.getName());
        replaceMap.put("com.horstmann.violet.InterfaceNode", InterfaceNode.class.getName());
        replaceMap.put("com.horstmann.violet.PackageNode", PackageNode.class.getName());
        replaceMap.put("com.horstmann.violet.DiagramLinkNode", DiagramLinkNode.class.getName());
        replaceMap.put("com.horstmann.violet.NoteEdge", NoteEdge.class.getName());
        replaceMap.put("com.horstmann.violet.NoteNode", NoteNode.class.getName());
        replaceMap.put("com.horstmann.violet.PointNode", PointNode.class.getName());
        replaceMap.put("com.horstmann.violet.FieldNode", FieldNode.class.getName());
        replaceMap.put("com.horstmann.violet.ObjectDiagramGraph", ObjectDiagramGraph.class.getName());
        replaceMap.put("com.horstmann.violet.ObjectNode", ObjectNode.class.getName());
        replaceMap.put("com.horstmann.violet.ObjectReferenceEdge", ObjectReferenceEdge.class.getName());
        replaceMap.put("com.horstmann.violet.ObjectRelationshipEdge", ObjectRelationshipEdge.class.getName());
        replaceMap.put("com.horstmann.violet.CallEdge", CallEdge.class.getName());
        replaceMap.put("com.horstmann.violet.CallNode", ActivationBarNode.class.getName());
        replaceMap.put("com.horstmann.violet.ImplicitParameterNode", LifelineNode.class.getName());
        replaceMap.put("com.horstmann.violet.ReturnEdge", ReturnEdge.class.getName());
        replaceMap.put("com.horstmann.violet.SequenceDiagramGraph", SequenceDiagramGraph.class.getName());
        replaceMap.put("com.horstmann.violet.CircularStateNode", CircularInitialStateNode.class.getName());
        replaceMap.put("com.horstmann.violet.StateDiagramGraph", StateDiagramGraph.class.getName());
        replaceMap.put("com.horstmann.violet.StateNode", StateNode.class.getName());
        replaceMap.put("com.horstmann.violet.StateTransitionEdge", StateTransitionEdge.class.getName());
        replaceMap.put("com.horstmann.violet.ActorNode", ActorNode.class.getName());
        replaceMap.put("com.horstmann.violet.UseCaseDiagramGraph", UseCaseDiagramGraph.class.getName());
        replaceMap.put("com.horstmann.violet.UseCaseNode", UseCaseNode.class.getName());
        replaceMap.put("com.horstmann.violet.UseCaseRelationshipEdge", UseCaseRelationshipEdge.class.getName());
        String original = FileFormatService.getInputStreamContent(in);
        String replaced = FileFormatService.replaceAll(original, replaceMap);
        try {
            return new ByteArrayInputStream(replaced.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
            return new ByteArrayInputStream(replaced.getBytes());
        }
    }

    private static String getInputStreamContent(InputStream in) {
        try {
            int numRead;
            InputStreamReader isr = new InputStreamReader(in, "UTF-8");
            StringBuffer buffer = new StringBuffer();
            int len = 1024;
            char[] buf = new char[len];
            while ((numRead = isr.read(buf, 0, len)) != -1) {
                buffer.append(buf, 0, numRead);
            }
            isr.close();
            return buffer.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String replaceAll(String input, Map<String, String> replaceMap) {
        Set<String> set = replaceMap.keySet();
        for (String searchedStr : set) {
            String replaceStr = replaceMap.get(searchedStr);
            input = input.replaceAll(searchedStr, replaceStr);
        }
        return input;
    }

    public static OutputStream convertToViolet016(OutputStream out) {
        Hashtable<String, String> replaceMap = new Hashtable<String, String>();
        replaceMap.put(BentStyle.class.getName(), "com.horstmann.violet.BentStyle");
        replaceMap.put(LineStyle.class.getName(), "com.horstmann.violet.LineStyle");
        replaceMap.put(ArrowHead.class.getName(), "com.horstmann.violet.ArrowHead");
        replaceMap.put(ClassDiagramGraph.class.getName(), "com.horstmann.violet.ClassDiagramGraph");
        replaceMap.put(ClassNode.class.getName(), "com.horstmann.violet.ClassNode");
        replaceMap.put(ClassRelationshipEdge.class.getName(), "com.horstmann.violet.ClassRelationshipEdge");
        replaceMap.put(InterfaceNode.class.getName(), "com.horstmann.violet.InterfaceNode");
        replaceMap.put(PackageNode.class.getName(), "com.horstmann.violet.PackageNode");
        replaceMap.put(DiagramLinkNode.class.getName(), "com.horstmann.violet.DiagramLinkNode");
        replaceMap.put(NoteEdge.class.getName(), "com.horstmann.violet.NoteEdge");
        replaceMap.put(NoteNode.class.getName(), "com.horstmann.violet.NoteNode");
        replaceMap.put(PointNode.class.getName(), "com.horstmann.violet.PointNode");
        replaceMap.put(FieldNode.class.getName(), "com.horstmann.violet.FieldNode");
        replaceMap.put(ObjectDiagramGraph.class.getName(), "com.horstmann.violet.ObjectDiagramGraph");
        replaceMap.put(ObjectNode.class.getName(), "com.horstmann.violet.ObjectNode");
        replaceMap.put(ObjectReferenceEdge.class.getName(), "com.horstmann.violet.ObjectReferenceEdge");
        replaceMap.put(ObjectRelationshipEdge.class.getName(), "com.horstmann.violet.ObjectRelationshipEdge");
        replaceMap.put(CallEdge.class.getName(), "com.horstmann.violet.CallEdge");
        replaceMap.put(ActivationBarNode.class.getName(), "com.horstmann.violet.CallNode");
        replaceMap.put(LifelineNode.class.getName(), "com.horstmann.violet.ImplicitParameterNode");
        replaceMap.put(ReturnEdge.class.getName(), "com.horstmann.violet.ReturnEdge");
        replaceMap.put(SequenceDiagramGraph.class.getName(), "com.horstmann.violet.SequenceDiagramGraph");
        replaceMap.put(CircularInitialStateNode.class.getName(), "com.horstmann.violet.CircularStateNode");
        replaceMap.put(StateDiagramGraph.class.getName(), "com.horstmann.violet.StateDiagramGraph");
        replaceMap.put(StateNode.class.getName(), "com.horstmann.violet.StateNode");
        replaceMap.put(StateTransitionEdge.class.getName(), "com.horstmann.violet.StateTransitionEdge");
        replaceMap.put(ActorNode.class.getName(), "com.horstmann.violet.ActorNode");
        replaceMap.put(UseCaseDiagramGraph.class.getName(), "com.horstmann.violet.UseCaseDiagramGraph");
        replaceMap.put(UseCaseNode.class.getName(), "com.horstmann.violet.UseCaseNode");
        replaceMap.put(UseCaseRelationshipEdge.class.getName(), "com.horstmann.violet.UseCaseRelationshipEdge");
        StringFilterOutputStream filteredOutputStream = new StringFilterOutputStream(out, replaceMap);
        return filteredOutputStream;
    }
}

