/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.framework.diagram;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JLabel;

public class MultiLineString
implements Serializable,
Cloneable {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    public static final int LARGE = 3;
    public static final int NORMAL = 4;
    public static final int SMALL = 5;
    private String text = "";
    private int justification = 1;
    private int size = 4;
    private boolean underlined = false;
    private transient JLabel label = new JLabel();

    public void setText(String newValue) {
        this.text = newValue;
        this.setLabelText();
    }

    public String getText() {
        return this.text;
    }

    public void setJustification(int newValue) {
        this.justification = newValue;
        this.setLabelText();
    }

    public int getJustification() {
        return this.justification;
    }

    public boolean isUnderlined() {
        return this.underlined;
    }

    public void setUnderlined(boolean newValue) {
        this.underlined = newValue;
        this.setLabelText();
    }

    public void setSize(int newValue) {
        this.size = newValue;
        this.setLabelText();
    }

    public int getSize() {
        return this.size;
    }

    public String toString() {
        return this.text.replace('\n', '|');
    }

    private void setLabelText() {
        StringBuffer prefix = new StringBuffer();
        StringBuffer suffix = new StringBuffer();
        StringBuffer htmlText = new StringBuffer();
        prefix.append("&nbsp;");
        suffix.insert(0, "&nbsp;");
        if (this.underlined) {
            prefix.append("<u>");
            suffix.insert(0, "</u>");
        }
        if (this.size == 3) {
            prefix.append("<font size=\"3\"><b>");
            suffix.insert(0, "</b></font>");
        }
        if (this.size == 5) {
            prefix.append("<font size=\"3\">");
            suffix.insert(0, "</font>");
        }
        htmlText.append("<html>");
        StringTokenizer tokenizer = new StringTokenizer(this.text, "\n");
        boolean first = true;
        while (tokenizer.hasMoreTokens()) {
            if (first) {
                first = false;
            } else {
                htmlText.append("<br>");
            }
            htmlText.append(prefix);
            htmlText.append(tokenizer.nextToken());
            htmlText.append(suffix);
        }
        htmlText.append("</html>");
        List<String> dontReplace = Arrays.asList("u", "i", "b", "tt", "font", "br");
        int ltpos = 0;
        while (ltpos != -1) {
            int end;
            if ((ltpos = htmlText.indexOf("<", ltpos + 1)) == -1 || ltpos + 1 < htmlText.length() && htmlText.charAt(ltpos + 1) == '/') continue;
            for (end = ltpos + 1; end < htmlText.length() && Character.isLetter(htmlText.charAt(end)); ++end) {
            }
            if (dontReplace.contains(htmlText.substring(ltpos + 1, end))) continue;
            htmlText.replace(ltpos, ltpos + 1, "&lt;");
        }
        this.label.setText(htmlText.toString());
        if (this.justification == 0) {
            this.label.setHorizontalAlignment(2);
        } else if (this.justification == 1) {
            this.label.setHorizontalAlignment(0);
        } else if (this.justification == 2) {
            this.label.setHorizontalAlignment(4);
        }
    }

    public Rectangle2D getBounds(Graphics2D g2) {
        this.label.setFont(g2.getFont());
        this.label.validate();
        if (this.text.length() == 0) {
            return new Rectangle2D.Double();
        }
        Dimension dim = this.label.getPreferredSize();
        return new Rectangle2D.Double(0.0, 0.0, dim.getWidth(), dim.getHeight());
    }

    public void draw(Graphics2D g2, Rectangle2D r) {
        this.label.setFont(g2.getFont());
        this.label.setBounds(0, 0, (int)r.getWidth(), (int)r.getHeight());
        g2.translate(r.getX(), r.getY());
        this.label.paint(g2);
        g2.translate(-r.getX(), -r.getY());
    }

    public MultiLineString clone() {
        try {
            MultiLineString cloned = (MultiLineString)super.clone();
            cloned.label = new JLabel();
            cloned.setLabelText();
            return cloned;
        }
        catch (CloneNotSupportedException exception) {
            return null;
        }
    }
}

